function func = gaussian(x, mean, variance, magnitude)
%RAMP   create a Gaussian distribution.
%
% USAGE:
%       func = gaussian(x, mean, variance, magnitude)
%
% ABOUT:
%       author: Bradley E. Treeby
%       date: 4th December 2009
%       last update: 4th December 2009
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)
% Copyright (C) 2009, 2010 Bradley Treeby and Ben Cox

% This file is part of k-Wave. k-Wave is free software: you can
% redistribute it and/or modify it under the terms of the GNU Lesser
% General Public License as published by the Free Software Foundation,
% either version 3 of the License, or (at your option) any later version.
% 
% k-Wave is distributed in the hope that it will be useful, but WITHOUT ANY
% WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
% FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
% more details. 
% 
% You should have received a copy of the GNU Lesser General Public License
% along with k-Wave. If not, see <http://www.gnu.org/licenses/>. 

% if the mean is not given, center the distribution
if nargin < 2
    mean = 0;
end

% if the variance is not given, define as unity
if nargin < 3
    variance = 1;
end

% if the magnitude is not given, normalise
if nargin < 4
    magnitude = (2*pi*variance)^-0.5;
end

% compute the gaussian
func = magnitude*exp(-(x - mean).^2/(2*variance));